/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.buchikripke.runtime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import obp2.core.IConfiguration;
import obp2.core.IFiredTransition;
import obp2.core.defaults.FiredTransition;
import obp2.language.buchi.runtime.BuchiConfiguration;
import obp2.language.buchikripke.runtime.KripkeBuchiConfiguration;
import obp2.language.buchikripke.runtime.KripkeBuchiLanguageModule;
import obp2.language.buchikripke.runtime.StutteringTransition;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.IMarshaller;
import obp2.runtime.core.defaults.DefaultLanguageService;
import plug.utils.Pair;
import plug.utils.marshaling.Marshaller;
import plug.utils.marshaling.Unmarshaller;
import properties.BuchiAutomata.BuchiAutomataModel.GuardedTransition;

public class KripkeBuchiMarshaller
extends DefaultLanguageService<KripkeBuchiConfiguration, Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition>, Void>
implements IMarshaller<KripkeBuchiConfiguration, Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition>, Void> {
    public KripkeBuchiMarshaller(KripkeBuchiLanguageModule languageModule) {
        this.setModule((ILanguageModule)languageModule);
    }

    ILanguageModule getKripke() {
        return ((KripkeBuchiLanguageModule)this.getModule()).kripke;
    }

    ILanguageModule getBuchi() {
        return ((KripkeBuchiLanguageModule)this.getModule()).buchi;
    }

    public byte[] serializeConfiguration(KripkeBuchiConfiguration configuration) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            byte[] kc = this.getKripke().getMarshaller().serializeConfiguration((Object)configuration.kripke);
            Marshaller.writeBuffer((byte[])kc, (OutputStream)bos);
            byte[] bc = this.getBuchi().getMarshaller().serializeConfiguration((Object)configuration.buchiState);
            Marshaller.writeBuffer((byte[])bc, (OutputStream)bos);
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] serializeFireable(Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition> fireable) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IFiredTransition kstep = (IFiredTransition)fireable.a;
        IMarshaller kmarshaller = this.getKripke().getMarshaller();
        try {
            byte[] ksource = kmarshaller.serializeConfiguration(kstep.getSource());
            Marshaller.writeBuffer((byte[])ksource, (OutputStream)bos);
            if (kstep.getAction() == StutteringTransition.instance) {
                Marshaller.writeBoolean((boolean)true, (OutputStream)bos);
            } else {
                Marshaller.writeBoolean((boolean)false, (OutputStream)bos);
                byte[] kaction = kmarshaller.serializeFireable(kstep.getAction());
                Marshaller.writeBuffer((byte[])kaction, (OutputStream)bos);
            }
            byte[] kpayload = kmarshaller.serializeOutput(kstep.getPayload());
            Marshaller.writeBuffer((byte[])kpayload, (OutputStream)bos);
            byte[] ktarget = kmarshaller.serializeConfiguration(kstep.getTargets().iterator().next());
            Marshaller.writeBuffer((byte[])ktarget, (OutputStream)bos);
            byte[] baction = this.getBuchi().getMarshaller().serializeFireable(fireable.b);
            Marshaller.writeBuffer((byte[])baction, (OutputStream)bos);
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public byte[] serializeOutput(Void output) {
        return new byte[0];
    }

    public KripkeBuchiConfiguration deserializeConfiguration(byte[] buffer) {
        ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
        try {
            byte[] kripkeC = Unmarshaller.readBuffer((InputStream)bis);
            IConfiguration kO = (IConfiguration)this.getKripke().getMarshaller().deserializeConfiguration(kripkeC);
            byte[] buchiC = Unmarshaller.readBuffer((InputStream)bis);
            BuchiConfiguration bO = (BuchiConfiguration)this.getBuchi().getMarshaller().deserializeConfiguration(buchiC);
            KripkeBuchiConfiguration kbc = new KripkeBuchiConfiguration();
            kbc.kripke = kO;
            kbc.buchiState = bO;
            return kbc;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition> deserializeFireable(byte[] buffer) {
        ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
        IMarshaller kmarshaller = this.getKripke().getMarshaller();
        try {
            byte[] ksb = Unmarshaller.readBuffer((InputStream)bis);
            IConfiguration ksource = (IConfiguration)kmarshaller.deserializeConfiguration(ksb);
            boolean isStuttering = Unmarshaller.readBoolean((InputStream)bis);
            Object kaction = null;
            if (isStuttering) {
                kaction = StutteringTransition.instance;
            } else {
                byte[] kab = Unmarshaller.readBuffer((InputStream)bis);
                kaction = kmarshaller.deserializeFireable(kab);
            }
            byte[] kpb = Unmarshaller.readBuffer((InputStream)bis);
            Object kpayload = kmarshaller.deserializeOutput(kpb);
            byte[] ktb = Unmarshaller.readBuffer((InputStream)bis);
            IConfiguration ktarget = (IConfiguration)kmarshaller.deserializeConfiguration(ktb);
            FiredTransition kstep = new FiredTransition((Object)ksource, (Object)ktarget, kaction, kpayload);
            byte[] bab = Unmarshaller.readBuffer((InputStream)bis);
            GuardedTransition baction = (GuardedTransition)this.getBuchi().getMarshaller().deserializeFireable(bab);
            return new Pair((Object)kstep, (Object)baction);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public Void deserializeOutput(byte[] buffer) {
        return null;
    }
}

