/*
 * Decompiled with CFR 0.152.
 */
package obp2.algorithms.buchi.nested_dfs;

import java.util.function.Supplier;
import obp2.algorithms.Color;
import obp2.algorithms.buchi.DefaultExecutionController;
import obp2.core.IBuchiConfiguration;
import obp2.core.IConfiguration;
import obp2.core.execution.IExecutionController;
import obp2.events.ExecutionEndedEvent;
import obp2.events.PropertyEvent;
import obp2.runtime.core.ITransitionRelation;

public class BA_CVWI_Recursive<C extends IBuchiConfiguration & IConfiguration, A>
extends DefaultExecutionController<C, A> {
    C seed;

    public BA_CVWI_Recursive(ITransitionRelation<C, A, ?> runtime) {
        super(runtime);
    }

    @Override
    public Supplier getMetadataSupplier() {
        return () -> Color.WHITE;
    }

    public void execute() {
        try {
            for (IBuchiConfiguration initial : this.getProductAutomaton().initialConfigurationsIterable()) {
                this.dfs(initial);
            }
        }
        catch (RuntimeException e) {
            this.announcer.announce((Object)new ExecutionEndedEvent((IExecutionController)this));
        }
    }

    public void dfs(C source) {
        this.setColor(source, Color.RED);
        for (IBuchiConfiguration target : this.getProductAutomaton().getPostIterable(source)) {
            if (this.monitor.atEnd()) break;
            if (this.getColor(target) == Color.RED) continue;
            this.dfs(target);
        }
        if (source.isAccepting()) {
            this.seed = source;
            this.ndfs(source);
        }
    }

    public void ndfs(C source) {
        this.setColor(source, Color.BLUE);
        for (IBuchiConfiguration target : this.getProductAutomaton().getPostIterable(source)) {
            if (this.monitor.atEnd()) break;
            if (this.getColor(target) != Color.BLUE) {
                this.ndfs(target);
                continue;
            }
            if (target != this.seed) continue;
            System.out.println("target = [" + target + "]");
            this.announcer.announce((Object)new PropertyEvent((IExecutionController)this, false, "property", null));
            throw new RuntimeException("Break execution flow");
        }
    }

    private Color getColor(C configuration) {
        return (Color)((Object)((IConfiguration)configuration).getMetadata());
    }

    private void setColor(C configuration, Color color) {
        ((IConfiguration)configuration).setMetadata((Object)color);
    }
}

