/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.value.ObservableValue;
import org.fxmisc.richtext.model.EditableStyledDocument;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.Replacement;
import org.fxmisc.richtext.model.RichTextChange;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.TwoDimensional;
import org.reactfx.EventSource;
import org.reactfx.EventStream;
import org.reactfx.Subscription;
import org.reactfx.Suspendable;
import org.reactfx.SuspendableEventStream;
import org.reactfx.SuspendableNo;
import org.reactfx.collection.ListChangeAccumulator;
import org.reactfx.collection.LiveList;
import org.reactfx.collection.LiveListBase;
import org.reactfx.collection.MaterializedListModification;
import org.reactfx.collection.QuasiListModification;
import org.reactfx.collection.SuspendableList;
import org.reactfx.collection.UnmodifiableByDefaultLiveList;
import org.reactfx.value.SuspendableVal;
import org.reactfx.value.Val;

class GenericEditableStyledDocumentBase<PS, SEG, S>
implements EditableStyledDocument<PS, SEG, S> {
    private ReadOnlyStyledDocument<PS, SEG, S> doc;
    private final EventSource<List<RichTextChange<PS, SEG, S>>> internalRichChangeList = new EventSource();
    private final SuspendableEventStream<List<RichTextChange<PS, SEG, S>>> richChangeList = this.internalRichChangeList.pausable();
    private final Val<String> internalText = Val.create(() -> this.doc.getText(), this.internalRichChangeList);
    private final SuspendableVal<String> text = this.internalText.suspendable();
    private final Val<Integer> internalLength = Val.create(() -> this.doc.length(), this.internalRichChangeList);
    private final SuspendableVal<Integer> length = this.internalLength.suspendable();
    private final EventSource<List<MaterializedListModification<Paragraph<PS, SEG, S>>>> parChangesList = new EventSource();
    private final SuspendableList<Paragraph<PS, SEG, S>> paragraphs = new ParagraphList().suspendable();
    private final SuspendableNo beingUpdated = new SuspendableNo();

    @Override
    public EventStream<List<RichTextChange<PS, SEG, S>>> multiRichChanges() {
        return this.richChangeList;
    }

    @Override
    public String getText() {
        return (String)this.text.getValue();
    }

    public Val<String> textProperty() {
        return this.text;
    }

    @Override
    public int getLength() {
        return (Integer)this.length.getValue();
    }

    @Override
    public Val<Integer> lengthProperty() {
        return this.length;
    }

    @Override
    public int length() {
        return (Integer)this.length.getValue();
    }

    @Override
    public LiveList<Paragraph<PS, SEG, S>> getParagraphs() {
        return this.paragraphs;
    }

    @Override
    public ReadOnlyStyledDocument<PS, SEG, S> snapshot() {
        return this.doc;
    }

    @Override
    public final SuspendableNo beingUpdatedProperty() {
        return this.beingUpdated;
    }

    @Override
    public final boolean isBeingUpdated() {
        return this.beingUpdated.get();
    }

    GenericEditableStyledDocumentBase(ReadOnlyStyledDocument<PS, SEG, S> initialContent) {
        this.doc = initialContent;
        Suspendable omniSuspendable = Suspendable.combine((Suspendable[])new Suspendable[]{this.text, this.length, this.richChangeList, this.paragraphs});
        omniSuspendable.suspendWhen((ObservableValue)this.beingUpdated);
    }

    GenericEditableStyledDocumentBase(Paragraph<PS, SEG, S> initialParagraph) {
        this(new ReadOnlyStyledDocument<PS, SEG, S>(Collections.singletonList(initialParagraph)));
    }

    GenericEditableStyledDocumentBase(PS initialParagraphStyle, S initialStyle, SegmentOps<SEG, S> segmentOps) {
        this(new Paragraph<PS, SEG, S>(initialParagraphStyle, segmentOps, segmentOps.createEmptySeg(), initialStyle));
    }

    @Override
    public TwoDimensional.Position position(int major, int minor) {
        return this.doc.position(major, minor);
    }

    @Override
    public TwoDimensional.Position offsetToPosition(int offset, TwoDimensional.Bias bias) {
        return this.doc.offsetToPosition(offset, bias);
    }

    @Override
    public void replaceMulti(List<Replacement<PS, SEG, S>> replacements) {
        this.doc.replaceMulti(replacements).exec(this::updateMulti);
    }

    @Override
    public void replace(int start, int end, StyledDocument<PS, SEG, S> replacement) {
        this.doc.replace(start, end, ReadOnlyStyledDocument.from(replacement)).exec(this::updateSingle);
    }

    @Override
    public void setStyle(int from, int to, S style) {
        this.doc.replace(from, to, removed -> removed.mapParagraphs(par -> par.restyle(style))).exec(this::updateSingle);
    }

    @Override
    public void setStyle(int paragraphIndex, S style) {
        this.doc.replaceParagraph(paragraphIndex, p -> p.restyle(style)).exec(this::updateSingle);
    }

    @Override
    public void setStyle(int paragraphIndex, int fromCol, int toCol, S style) {
        this.doc.replace(paragraphIndex, fromCol, toCol, d -> d.mapParagraphs(p -> p.restyle(style))).exec(this::updateSingle);
    }

    @Override
    public void setStyleSpans(int from, StyleSpans<? extends S> styleSpans) {
        int len = styleSpans.length();
        this.doc.replace(from, from + len, d -> {
            TwoDimensional.Position i = styleSpans.position(0, 0);
            ArrayList pars = new ArrayList(d.getParagraphs().size());
            for (Paragraph p : d.getParagraphs()) {
                TwoDimensional.Position j = i.offsetBy(p.length(), TwoDimensional.Bias.Backward);
                StyleSpans spans = styleSpans.subView(i, j);
                pars.add(p.restyle(0, spans));
                i = j.offsetBy(1, TwoDimensional.Bias.Forward);
            }
            return new ReadOnlyStyledDocument(pars);
        }).exec(this::updateSingle);
    }

    @Override
    public void setStyleSpans(int paragraphIndex, int from, StyleSpans<? extends S> styleSpans) {
        this.setStyleSpans(this.doc.position(paragraphIndex, from).toOffset(), styleSpans);
    }

    @Override
    public void setParagraphStyle(int paragraphIndex, PS style) {
        this.doc.replaceParagraph(paragraphIndex, p -> p.setParagraphStyle(style)).exec(this::updateSingle);
    }

    @Override
    public StyledDocument<PS, SEG, S> concat(StyledDocument<PS, SEG, S> that) {
        return this.doc.concat((StyledDocument)that);
    }

    @Override
    public StyledDocument<PS, SEG, S> subSequence(int start, int end) {
        return this.doc.subSequence(start, end);
    }

    private void updateSingle(ReadOnlyStyledDocument<PS, SEG, S> newValue, RichTextChange<PS, SEG, S> change, MaterializedListModification<Paragraph<PS, SEG, S>> parChange) {
        this.updateMulti(newValue, Collections.singletonList(change), Collections.singletonList(parChange));
    }

    private void updateMulti(ReadOnlyStyledDocument<PS, SEG, S> newValue, List<RichTextChange<PS, SEG, S>> richChanges, List<MaterializedListModification<Paragraph<PS, SEG, S>>> parChanges) {
        this.doc = newValue;
        this.beingUpdated.suspendWhile(() -> {
            this.internalRichChangeList.push((Object)richChanges);
            this.parChangesList.push((Object)parChanges);
        });
    }

    private class ParagraphList
    extends LiveListBase<Paragraph<PS, SEG, S>>
    implements UnmodifiableByDefaultLiveList<Paragraph<PS, SEG, S>> {
        private ParagraphList() {
        }

        public Paragraph<PS, SEG, S> get(int index) {
            return GenericEditableStyledDocumentBase.this.doc.getParagraph(index);
        }

        public int size() {
            return GenericEditableStyledDocumentBase.this.doc.getParagraphCount();
        }

        protected Subscription observeInputs() {
            return GenericEditableStyledDocumentBase.this.parChangesList.subscribe(list -> {
                ListChangeAccumulator accumulator = new ListChangeAccumulator();
                for (MaterializedListModification mod : list) {
                    mod = mod.trim();
                    accumulator.add(QuasiListModification.create((int)mod.getFrom(), (List)mod.getRemoved(), (int)mod.getAddedSize()));
                }
                this.notifyObservers(accumulator.asListChange());
            });
        }
    }
}

